﻿#include <iostream>
#include <vector>
#include <algorithm>
#include <unordered_map>

using namespace std;

const int N = 1e6 + 3;
int lp[N + 1];
vector<int> pr;

using ll = long long;

int main()
{
	ios_base::sync_with_stdio(false);
	cout.tie(0);
	cin.tie(0);

	for (int i = 2; i <= N; ++i) {
		if (lp[i] == 0) {
			lp[i] = i;
			pr.push_back(i);
		}
		for (int j = 0; j < (int)pr.size() && pr[j] <= lp[i] && i * pr[j] <= N; ++j)
			lp[i * pr[j]] = pr[j];
	}

	int m;
	cin >> m;

	int l, r;
	cin >> l >> r;

	int prev = 0;

	bool done = false;

	for (int i = l; i <= r; i++) {
		unordered_map<int, int> cnt;
		int nm = i;
		
		while (nm > 1) {
			cnt[lp[nm]]++;
			nm /= lp[nm];
		}

		bool flag = true;

		for (auto i : cnt) {
			if (i.second % 2 == 0) {
				flag = false;
				break;
			}
		}

		if (flag) {
			prev++;
		}
		else {
			prev = 0;
		}

		if (prev >= m) {
			done = true;
			for (int j = i - m + 1; j <= i; j++) {
				cout << j << ' ';
			}
			break;
		}
	}

	if (done) return 0;
	cout << -1;
	
}
