﻿#include <bits/stdc++.h>
using namespace std;

struct Rect {
    int64_t x1, y1, x2, y2;
};

bool can_line_touch_all(const vector<Rect>& rects) {
    int64_t x_min = INT64_MIN, x_max = INT64_MAX;
    int64_t y_min = INT64_MIN, y_max = INT64_MAX;
    int64_t d1_min = INT64_MIN, d1_max = INT64_MAX; // for 45°: x+y
    int64_t d2_min = INT64_MIN, d2_max = INT64_MAX; // for 135°: x-y

    for (auto& r : rects) {
        // Horizontal line must be between y1 <= y <= y2 for all
        y_min = max(y_min, r.y1);
        y_max = min(y_max, r.y2);

        // Vertical line must be between x1 <= x <= x2 for all
        x_min = max(x_min, r.x1);
        x_max = min(x_max, r.x2);

        // Diagonal line at 45° touches rectangle if (x+y) is between (x1+y1) and (x2+y2)
        d1_min = max(d1_min, r.x1 + r.y1);
        d1_max = min(d1_max, r.x2 + r.y2);

        // Diagonal line at 135° touches rectangle if (x-y) is between (x1 - y2) and (x2 - y1)
        d2_min = max(d2_min, r.x1 - r.y2);
        d2_max = min(d2_max, r.x2 - r.y1);

        if (y_min > y_max && x_min > x_max && d1_min > d1_max && d2_min > d2_max)
            return false; // early break if no intervals overlap
    }

    // If any interval overlaps, that means such a line exists
    if (y_min <= y_max) return true;
    if (x_min <= x_max) return true;
    if (d1_min <= d1_max) return true;
    if (d2_min <= d2_max) return true;
    return false;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T; cin >> T;
    while (T--) {
        int n; cin >> n;
        vector<Rect> rects(n);
        for (int i = 0; i < n; i++) {
            int64_t x1, y1, x2, y2;
            cin >> x1 >> y1 >> x2 >> y2;
            rects[i] = {x1, y1, x2, y2};
        }
        cout << (can_line_touch_all(rects) ? "Yes" : "No") << "\n";
    }
    return 0;
}
