﻿using System;
using System.Collections.Generic;

static class Program
{
    static void NormalizeLine(ref double a, ref double b, ref double c)
    {
        double norm = Math.Sqrt(a * a + b * b);
        if (norm == 0)
        {
            a = b = c = 0;
            return;
        }
        a /= norm;
        b /= norm;
        c /= norm;

        if (a < 0 || (Math.Abs(a) < 1e-15 && b < 0))
        {
            a = -a; b = -b; c = -c;
        }
    }

    static bool IntersectsLine((long x1, long y1, long x2, long y2) rect, double a, double b, double c)
    {
        long x1 = rect.x1, y1 = rect.y1, x2 = rect.x2, y2 = rect.y2;
        var corners = new (long x, long y)[]
            { (x1, y1), (x1, y2), (x2, y1), (x2, y2) };

        foreach (var (x, y) in corners)
        {
            if (Math.Abs(a * x + b * y + c) < 1e-12) return true;
        }

        double[] signs = new double[4];
        for (int i = 0; i < 4; i++)
            signs[i] = a * corners[i].x + b * corners[i].y + c;

        bool EdgeCheck(int i1, int i2)
        {
            return signs[i1] * signs[i2] <= 0;
        }

        return EdgeCheck(0, 1) || EdgeCheck(0, 2) || EdgeCheck(2, 3) || EdgeCheck(1, 3);
    }

    static bool CheckAllLines(List<(long x1, long y1, long x2, long y2)> rects)
    {
        int n = rects.Count;
        if (n <= 2) return true;

        var corners = new List<(long x, long y)>();
        foreach (var r in rects)
        {
            corners.Add((r.x1, r.y1));
            corners.Add((r.x1, r.y2));
            corners.Add((r.x2, r.y1));
            corners.Add((r.x2, r.y2));
        }

        var linesSeen = new HashSet<(long a, long b, long c)>();

        for (int i = 0; i < corners.Count; i++)
        {
            for (int j = i + 1; j < corners.Count; j++)
            {
                var p1 = corners[i];
                var p2 = corners[j];

                if (p1.x == p2.x && p1.y == p2.y) continue;

                double a = p1.y - p2.y;
                double b = p2.x - p1.x;
                double c = p1.x * p2.y - p2.x * p1.y;

                NormalizeLine(ref a, ref b, ref c);

                var key = ((long)(a * 1e12), (long)(b * 1e12), (long)(c * 1e12));
                if (linesSeen.Contains(key)) continue;

                linesSeen.Add(key);

                bool allIntersect = true;
                foreach (var r in rects)
                {
                    if (!IntersectsLine(r, a, b, c))
                    {
                        allIntersect = false;
                        break;
                    }
                }
                if (allIntersect) return true;
            }
        }
        return false;
    }

    static void Main()
    {
        int T = int.Parse(Console.ReadLine());
        var results = new List<string>(T);
        for (int _ = 0; _ < T; _++)
        {
            int n = int.Parse(Console.ReadLine());
            var rects = new List<(long x1, long y1, long x2, long y2)>(n);
            for (int __ = 0; __ < n; __++)
            {
                string line = Console.ReadLine();
                while (string.IsNullOrWhiteSpace(line))
                    line = Console.ReadLine();

                var parts = line.Split(' ');
                long x1 = long.Parse(parts[0]);
                long y1 = long.Parse(parts[1]);
                long x2 = long.Parse(parts[2]);
                long y2 = long.Parse(parts[3]);
                rects.Add((x1, y1, x2, y2));
            }
            results.Add(CheckAllLines(rects) ? "Yes" : "No");
        }
        Console.WriteLine(string.Join("\n", results));
    }
}
