﻿using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        string[] lines = Console.ReadLine().Split();
        int T = int.Parse(lines[0]);

        for (int t = 0; t < T; t++)
        {
            int n = int.Parse(Console.ReadLine().Trim());
            List<(long x1, long y1, long x2, long y2)> rects = new List<(long, long, long, long)>();

            for (int i = 0; i < n; i++)
            {
                string line;
                do
                {
                    line = Console.ReadLine().Trim();
                } while (string.IsNullOrEmpty(line));

                string[] parts = line.Split();
                long x1 = long.Parse(parts[0]);
                long y1 = long.Parse(parts[1]);
                long x2 = long.Parse(parts[2]);
                long y2 = long.Parse(parts[3]);
                rects.Add((x1, y1, x2, y2));
            }

            Console.WriteLine(CheckAllLines(rects) ? "Yes" : "No");
        }
    }

    static bool IntersectsLine((long x1, long y1, long x2, long y2) rect, double a, double b, double c)
    {
        long x1 = rect.x1, y1 = rect.y1, x2 = rect.x2, y2 = rect.y2;

        double[] corners = {
            a * x1 + b * y1 + c,
            a * x1 + b * y2 + c,
            a * x2 + b * y1 + c,
            a * x2 + b * y2 + c
        };

        foreach (double val in corners)
        {
            if (Math.Abs(val) < 1e-9) return true;
        }

        return (Math.Min(corners[0], corners[1]) * Math.Max(corners[0], corners[1]) <= 0) ||
               (Math.Min(corners[0], corners[2]) * Math.Max(corners[0], corners[2]) <= 0) ||
               (Math.Min(corners[2], corners[3]) * Math.Max(corners[2], corners[3]) <= 0) ||
               (Math.Min(corners[1], corners[3]) * Math.Max(corners[1], corners[3]) <= 0);
    }

    static bool CheckAllLines(List<(long x1, long y1, long x2, long y2)> rects)
    {
        int n = rects.Count;
        if (n <= 2) return true;

        List<(long x, long y)> corners = new List<(long, long)>();
        foreach (var rect in rects)
        {
            corners.Add((rect.x1, rect.y1));
            corners.Add((rect.x1, rect.y2));
            corners.Add((rect.x2, rect.y1));
            corners.Add((rect.x2, rect.y2));
        }

        HashSet<string> seenLines = new HashSet<string>();

        for (int i = 0; i < corners.Count; i++)
        {
            for (int j = i + 1; j < corners.Count; j++)
            {
                long x1 = corners[i].x, y1 = corners[i].y;
                long x2 = corners[j].x, y2 = corners[j].y;

                if (Math.Abs(x2 - x1) < 1e-9 && Math.Abs(y2 - y1) < 1e-9) continue;

                double a = y1 - y2;
                double b = x2 - x1;
                double c = x1 * y2 - x2 * y1;

                double norm = Math.Sqrt(a * a + b * b);
                if (norm > 1e-9)
                {
                    a /= norm;
                    b /= norm;
                    c /= norm;

                    if (a < 0 || (Math.Abs(a) < 1e-9 && b < 0))
                    {
                        a = -a; b = -b; c = -c;
                    }
                }

                string lineKey = $"{a:F12},{b:F12},{c:F12}";
                if (seenLines.Contains(lineKey)) continue;
                seenLines.Add(lineKey);

                bool allIntersect = true;
                foreach (var rect in rects)
                {
                    if (!IntersectsLine(rect, a, b, c))
                    {
                        allIntersect = false;
                        break;
                    }
                }

                if (allIntersect) return true;
            }
        }

        return false;
    }
}
