import sys
from math import sqrt, isclose

def normalize_line(a, b, c):
    norm = sqrt(a*a + b*b)
    if norm == 0:
        return (0,0,0)
    a /= norm
    b /= norm
    c /= norm
    if a < 0 or (isclose(a, 0) and b < 0):
        a, b, c = -a, -b, -c
    return (a, b, c)

def intersects_line(rect, a, b, c):
    x1, y1, x2, y2 = rect
    corners = [(x1,y1), (x1,y2), (x2,y1), (x2,y2)]
    for x, y in corners:
        if abs(a*x + b*y + c) < 1e-12:
            return True
    def sign(x, y):
        return a*x + b*y + c
    signs = [sign(x1,y1), sign(x1,y2), sign(x2,y1), sign(x2,y2)]
    edges_check = [
        (signs[0], signs[1]),
        (signs[0], signs[2]),
        (signs[2], signs[3]),
        (signs[1], signs[3])
    ]
    for s1, s2 in edges_check:
        if s1 * s2 <= 0:
            return True
    return False

def check_all_lines(rects):
    n = len(rects)
    if n <= 2:
        return True

    corners = []
    for r in rects:
        x1,y1,x2,y2 = r
        corners.extend([(x1,y1),(x1,y2),(x2,y1),(x2,y2)])

    lines_seen = set()
    for i in range(len(corners)):
        for j in range(i+1, len(corners)):
            x1, y1 = corners[i]
            x2, y2 = corners[j]
            if isclose(x1, x2) and isclose(y1, y2):
                continue
            a = y1 - y2
            b = x2 - x1
            c = x1*y2 - x2*y1
            a, b, c = normalize_line(a, b, c)
            line_key = (round(a*1e12), round(b*1e12), round(c*1e12))
            if line_key in lines_seen:
                continue
            lines_seen.add(line_key)
            if all(intersects_line(r, a, b, c) for r in rects):
                return True
    return False

input = sys.stdin.readline
T = int(input().strip())

results = []
for _ in range(T):
    n = int(input().strip())
    rects = []
    for __ in range(n):
        line = input().strip()
        while not line:
            line = input().strip()
        x1, y1, x2, y2 = map(int, line.split())
        rects.append((x1, y1, x2, y2))
    results.append("Yes" if check_all_lines(rects) else "No")

print("\n".join(results))
