import sys


def intersects_line(rect, a, b, c):
    x1, y1, x2, y2 = rect
    corners = [(x1, y1), (x1, y2), (x2, y1), (x2, y2)]
    for x, y in corners:
        if abs(a * x + b * y + c) < 1e-9:
            return True
    return (min(a * x1 + b * y1 + c, a * x1 + b * y2 + c) * max(a * x1 + b * y1 + c, a * x1 + b * y2 + c) <= 0 or
            min(a * x1 + b * y1 + c, a * x2 + b * y1 + c) * max(a * x1 + b * y1 + c, a * x2 + b * y1 + c) <= 0 or
            min(a * x2 + b * y1 + c, a * x2 + b * y2 + c) * max(a * x2 + b * y1 + c, a * x2 + b * y2 + c) <= 0 or
            min(a * x1 + b * y2 + c, a * x2 + b * y2 + c) * max(a * x1 + b * y2 + c, a * x2 + b * y2 + c) <= 0)


def check_all_lines(rects):
    n = len(rects)
    if n <= 2:
        return True

    corners_all = []
    for rect in rects:
        x1, y1, x2, y2 = rect
        corners_all.extend([(x1, y1), (x1, y2), (x2, y1), (x2, y2)])

    for i in range(len(corners_all)):
        for j in range(i + 1, len(corners_all)):
            p1, p2 = corners_all[i], corners_all[j]
            x1, y1 = p1
            x2, y2 = p2
            if abs(x2 - x1) < 1e-9 and abs(y2 - y1) < 1e-9:
                continue
            a = y1 - y2
            b = x2 - x1
            c = x1 * y2 - x2 * y1
            norm = (a * a + b * b) ** 0.5
            if norm > 0:
                a, b, c = a / norm, b / norm, c / norm
            if all(intersects_line(rect, a, b, c) for rect in rects):
                return True
    return False


input = sys.stdin.readline
T = int(input().strip())

results = []
for _ in range(T):
    n = int(input().strip())
    rects = []
    for __ in range(n):
        line = input().strip()
        if line:
            x1, y1, x2, y2 = map(int, line.split())
            rects.append((x1, y1, x2, y2))
    results.append("Yes" if check_all_lines(rects) else "No")

print("\n".join(results))
