import sys

sys.setrecursionlimit(10 ** 6)
M = 1000000007


def Main():
    inputLine = sys.stdin.readline().split()
    length = int(inputLine[0])
    modK = int(inputLine[1])
    numDec = sys.stdin.readline().strip()

    binStr = ConvertDecimalToBinary(numDec)

    dp = [[[-1 for _ in range(2)] for _ in range(modK)] for _ in range(len(binStr) + 1)]

    ans = CalculateCountDp(0, 0, 1, binStr, modK, dp)
    print(ans)


def ConvertDecimalToBinary(decimalStr: str) -> str:
    if decimalStr == "0":
        return "0"

    binaryDigits = []
    currentNum = list(decimalStr)

    while any(d != '0' for d in currentNum):
        remainder = 0
        newNum = []

        for digitChar in currentNum:
            currentDigit = remainder * 10 + int(digitChar)
            newNum.append(str(currentDigit // 2))
            remainder = currentDigit % 2

        # Remove leading zeros
        startIdx = 0
        while startIdx < len(newNum) and newNum[startIdx] == '0':
            startIdx += 1

        currentNum = newNum[startIdx:] if startIdx < len(newNum) else ['0']
        binaryDigits.append(str(remainder))

    binaryDigits.reverse()
    return ''.join(binaryDigits)


def CalculateCountDp(pos: int, popMod: int, tight: int, binStr: str, K: int, dp: list) -> int:
    if pos == len(binStr):
        return 1 if popMod == 0 else 0

    if dp[pos][popMod][tight] != -1:
        return dp[pos][popMod][tight]

    result = 0
    upperLimit = int(binStr[pos]) if tight else 1

    for bit in range(upperLimit + 1):
        newTight = 1 if tight and bit == upperLimit else 0
        newPopMod = (popMod + bit) % K
        result = (result + CalculateCountDp(pos + 1, newPopMod, newTight, binStr, K, dp)) % M

    dp[pos][popMod][tight] = result
    return result


if __name__ == "__main__":
    Main()
