import sys
sys.setrecursionlimit(10**7)
MOD = 10**9 + 7

def Main():
    n, K = map(int, sys.stdin.readline().split())
    R = sys.stdin.readline().strip()

    binStr = DecimalToBinary(R)

    dp = [[[-1 for _ in range(2)] for _ in range(K)] for _ in range(len(binStr)+1)]

    def Dfs(pos, modPopcount, isTight):
        if pos == len(binStr):
            return 1 if modPopcount == 0 else 0

        if dp[pos][modPopcount][isTight] != -1:
            return dp[pos][modPopcount][isTight]

        limit = int(binStr[pos]) if isTight else 1
        res = 0
        for bit in range(limit + 1):
            res += Dfs(pos + 1,
                       (modPopcount + bit) % K,
                       isTight and (bit == limit))
        dp[pos][modPopcount][isTight] = res % MOD
        return dp[pos][modPopcount][isTight]

    ans = Dfs(0, 0, True)
    print(ans % MOD)

def DecimalToBinary(decStr):
    s = decStr
    res = []
    while len(s) > 1 or s[0] != '0':
        remainder = 0
        new_s = []
        for ch in s:
            digit = remainder * 10 + (ord(ch) - ord('0'))
            new_digit = digit // 2
            remainder = digit % 2
            if len(new_s) > 0 or new_digit > 0:
                new_s.append(str(new_digit))
        res.append(str(remainder))
        s = ''.join(new_s) if new_s else "0"
        if s == '0':
            break
    res.reverse()
    return ''.join(res) if res else '0'

if __name__ == "__main__":
    Main()
