MOD = 10**9 + 7

def DecimalToBinary(decimal_str: str) -> str:
    return bin(int(decimal_str))[2:]

def CountNumbersWithPopcountModK(R: str, K: int) -> int:
    binary = DecimalToBinary(R)
    n = len(binary)

    from functools import lru_cache

    @lru_cache(None)
    def Dp(pos: int, isLess: int, popMod: int) -> int:
        if pos == n:
            return 1 if popMod == 0 else 0

        limit = 1 if isLess else int(binary[pos])

        result = 0
        for bit in range(limit + 1):
            nxtIsLess = isLess or (bit < limit)
            nxtPopMod = (popMod + bit) % K
            result += Dp(pos + 1, nxtIsLess, nxtPopMod)
            if result >= MOD:
                result -= MOD
        return result
    return Dp(0, 0, 0)


if __name__ == "__main__":
    n, K = map(int, input().split())
    R = input().strip()
    print(CountNumbersWithPopcountModK(R, K))
