import sys

M = 1000000007


def Main():
    input_line = sys.stdin.readline().split()
    length = int(input_line[0])
    modK = int(input_line[1])
    numDec = sys.stdin.readline().strip()

    R = ParseDecimal(numDec)
    binList = ConvertToBinary(R)
    ans = CalculateCount(binList, modK)
    print(ans)


def ParseDecimal(s: str) -> int:
    val = 0
    for ch in s:
        val = val * 10 + (ord(ch) - ord('0'))
    return val


def ConvertToBinary(x: int) -> list[int]:
    if x == 0:
        return [0]
    res = []
    while x > 0:
        res.append(x & 1)
        x >>= 1
    res.reverse()
    return res


def CalculateCount(bits: list[int], k: int) -> int:
    n = len(bits)

    prev = [[0] * 2 for _ in range(k)]
    curr = [[0] * 2 for _ in range(k)]
    prev[0][1] = 1

    for i in range(n):
        for pc in range(k):
            curr[pc][0] = 0
            curr[pc][1] = 0

        bit = bits[i]
        for pc in range(k):
            for t in range(2):
                cur = prev[pc][t]
                if cur == 0:
                    continue

                maxBit = bit if t == 1 else 1
                for b in range(maxBit + 1):
                    np_ = (pc + b) % k
                    nt = 1 if (t == 1 and b == maxBit) else 0
                    curr[np_][nt] = (curr[np_][nt] + cur) % M

        prev, curr = curr, prev

    return (prev[0][0] + prev[0][1]) % M


if __name__ == "__main__":
    Main()
