MOD = 10 ** 9 + 7


class HamsterSchoolSolution:
    def __init__(self, n, K, R):
        self.n = n
        self.K = K
        num = int(R)
        self.bits = []
        while num:
            self.bits.append(num & 1)
            num >>= 1
        if not self.bits: self.bits = [0]
        self.bits.reverse()
        self.L = len(self.bits)

    def CountValidNumbers(self):
        K = self.K
        L = self.L
        bits = self.bits

        dp_next = [0] * (K * 2)
        dp_curr = [0] * (K * 2)

        for p in range(K):
            idx0 = p * 2 + 0
            idx1 = p * 2 + 1
            dp_next[idx0] = 1 if p == 0 else 0
            dp_next[idx1] = dp_next[idx0]

        for pos in range(L - 1, -1, -1):
            limit_bit = bits[pos]

            for p in range(K):
                idx0 = p * 2 + 0
                idx1 = p * 2 + 1

                res1 = 0
                res1 = (res1 + dp_next[p * 2 + 1]) % MOD
                res1 = (res1 + dp_next[((p + 1) % K) * 2 + 1]) % MOD
                dp_curr[idx1] = res1

                limit = limit_bit
                res0 = 0
                res0 = (res0 + dp_next[((p + 0) % K) * 2 + 1]) % MOD
                if limit == 1:
                    res0 = (res0 + dp_next[((p + 1) % K) * 2 + 0]) % MOD
                dp_curr[idx0] = res0

            dp_next, dp_curr = dp_curr, dp_next

        return dp_next[0]
