﻿using System;
using System.Collections.Generic;
using System.Numerics;

public static class Program
{
    const int M = 1000000007;

    public static void Main()
    {
        var input = Console.ReadLine().Split();
        int len = int.Parse(input[0]);
        int modK = int.Parse(input[1]);
        string numDec = Console.ReadLine();

        BigInteger R = ParseDecimal(numDec);
        var bin = ConvertToBinary(R);
        long ans = CalculateCount(bin, modK);
        Console.WriteLine(ans);
    }

    static BigInteger ParseDecimal(string s)
    {
        BigInteger val = 0;
        foreach (var ch in s)
        {
            val = val * 10 + (ch - '0');
        }
        return val;
    }

    static List<int> ConvertToBinary(BigInteger x)
    {
        if (x == 0) return new List<int> { 0 };
        var res = new List<int>();
        while (x > 0)
        {
            res.Add((int)(x & 1));
            x >>= 1;
        }
        res.Reverse();
        return res;
    }

    static long CalculateCount(List<int> bits, int k)
    {
        int n = bits.Count;
        long[,,] f = new long[n + 1, k, 2];
        f[0, 0, 1] = 1;

        for (int i = 0; i < n; i++)
        {
            for (int pc = 0; pc < k; pc++)
            {
                for (int t = 0; t < 2; t++)
                {
                    var cur = f[i, pc, t];
                    if (cur == 0) continue;

                    int maxBit = t == 1 ? bits[i] : 1;
                    for (int b = 0; b <= maxBit; b++)
                    {
                        int np = (pc + b) % k;
                        int nt = (t == 1 && b == maxBit) ? 1 : 0;
                        f[i + 1, np, nt] = (f[i + 1, np, nt] + cur) % M;
                    }
                }
            }
        }

        return (f[n, 0, 0] + f[n, 0, 1]) % M;
    }
}
