MOD = 10**9 + 7

class HamsterSchoolSolution:
    def __init__(self, n, K, R):
        self.n = n
        self.K = K

        num = int(R)
        self.binR = []
        while num > 0:
            self.binR.append(num & 1)
            num >>= 1
        if not self.binR:
            self.binR = [0]
        self.binR.reverse()
        self.lenBin = len(self.binR)

    def CountValidNumbers(self):
        K = self.K
        dp_next = [[0, 0] for _ in range(K)]
        dp_curr = [[0, 0] for _ in range(K)]


        for popMod in range(K):
            dp_next[popMod][0] = 1 if popMod == 0 else 0
            dp_next[popMod][1] = dp_next[popMod][0]

        for pos in reversed(range(self.lenBin)):
            limit_bit = self.binR[pos]

            for popMod in range(K):
                for isLess in (0, 1):
                    res = 0
                    limit = 1 if isLess else limit_bit
                    for bit in range(limit + 1):
                        newIsLess = isLess or (bit < limit)
                        newPopMod = (popMod + bit) % K
                        res += dp_next[newPopMod][newIsLess]
                    dp_curr[popMod][isLess] = res % MOD

            dp_next, dp_curr = dp_curr, dp_next

        return dp_next[0][0]


def Main():
    import sys
    n, K = map(int, sys.stdin.readline().split())
    R = sys.stdin.readline().strip()
    solver = HamsterSchoolSolution(n, K, R)
    print(solver.CountValidNumbers())


if __name__ == "__main__":
    Main()
