MOD = 10 ** 9 + 7


class HamsterSchoolSolution:
    def __init__(self, n, K, R):
        self.n = n
        self.K = K
        self.R = R
        self.binR = self.DecimalToBinary(R)
        self.lenBin = len(self.binR)

    def DecimalToBinary(self, decStr):
        num = int(decStr)
        if num == 0:
            return "0"
        return bin(num)[2:]

    def CountValidNumbers(self):
        dp = [[[0 for _ in range(2)] for _ in range(self.K)] for _ in range(self.lenBin + 1)]

        for pos in range(self.lenBin, -1, -1):
            for popMod in range(self.K):
                for isLess in range(2):
                    if pos == self.lenBin:
                        dp[pos][popMod][isLess] = 1 if popMod == 0 else 0
                        continue

                    limit = 1 if isLess else int(self.binR[pos])
                    for bit in range(limit + 1):
                        newIsLess = 1 if isLess or (bit < limit) else 0
                        newPopMod = (popMod + bit) % self.K
                        dp[pos][popMod][isLess] = (dp[pos][popMod][isLess] + dp[pos + 1][newPopMod][newIsLess]) % MOD

        return dp[0][0][0]


def Main():
    import sys
    n, K = map(int, sys.stdin.readline().split())
    R = sys.stdin.readline().strip()
    solver = HamsterSchoolSolution(n, K, R)
    print(solver.CountValidNumbers())


if __name__ == "__main__":
    Main()
