MOD = 10 ** 9 + 7


class HamsterSchoolSolution:
    def __init__(self, n, K, R):
        self.n = n
        self.K = K
        self.R = R
        self.binR = self.DecimalToBinary(R)
        self.lenBin = len(self.binR)

    def DecimalToBinary(self, decStr):
        num = int(decStr)
        if num == 0:
            return "0"
        return bin(num)[2:]

    def CountValidNumbers(self):
        dp = [[[-1 for _ in range(2)] for _ in range(self.K)] for _ in range(self.lenBin + 1)]

        def Dfs(pos, popMod, isLess):
            if pos == self.lenBin:
                return 1 if popMod == 0 else 0

            if dp[pos][popMod][isLess] != -1:
                return dp[pos][popMod][isLess]

            limit = 1 if isLess else int(self.binR[pos])
            result = 0
            for bit in range(limit + 1):
                newIsLess = 1 if isLess or (bit < limit) else 0
                newPopMod = (popMod + bit) % self.K
                result = (result + Dfs(pos + 1, newPopMod, newIsLess)) % MOD

            dp[pos][popMod][isLess] = result
            return result

        return Dfs(0, 0, 0)


def Main():
    import sys
    sys.setrecursionlimit(10 ** 6)
    n, K = map(int, sys.stdin.readline().split())
    R = sys.stdin.readline().strip()
    solver = HamsterSchoolSolution(n, K, R)
    print(solver.CountValidNumbers())


if __name__ == "__main__":
    Main()
