MOD = 10**9 + 7

class HamsterSchoolSolution:
    def __init__(self, n, K, R):
        self.n = n
        self.K = K
        self.R = R
        self.binR = self.DecimalToBinary(R)
        self.lenBin = len(self.binR)

    def DecimalToBinary(self, decStr):
        num = int(decStr)
        if num == 0:
            return "0"
        return bin(num)[2:]

    def CountValidNumbers(self):
        from functools import lru_cache

        @lru_cache(None)
        def Dfs(pos, popMod, isLess):
            if pos == self.lenBin:
                return 1 if popMod == 0 else 0

            limit = 1 if isLess else int(self.binR[pos])
            result = 0
            for bit in range(limit + 1):
                newIsLess = isLess or (bit < limit)
                newPopMod = (popMod + bit) % self.K
                result += Dfs(pos + 1, newPopMod, newIsLess)
                if result >= MOD:
                    result -= MOD
            return result

        return Dfs(0, 0, False) % MOD


def Main():
    import sys
    sys.setrecursionlimit(10**7)
    n, K = map(int, sys.stdin.readline().split())
    R = sys.stdin.readline().strip()
    solver = HamsterSchoolSolution(n, K, R)
    print(solver.CountValidNumbers())


if __name__ == "__main__":
    Main()
