import sys

MOD = 10**9 + 7

class Solution:
    def Main(self):
        input_line = sys.stdin.readline().split()
        n = int(input_line[0])
        k = int(input_line[1])
        rStr = sys.stdin.readline().strip()

        num = int(rStr)
        if num == 0:
            print(1)
            return

        bits = []
        while num > 0:
            bits.append(num & 1)
            num >>= 1
        bits.reverse()
        bit_len = len(bits)

        dp = [[0]*k for _ in range(2)]
        dp[1][0] = 1

        for i in range(bit_len):
            upper = bits[i]
            next_dp = [[0]*k for _ in range(2)]

            for tight in (0,1):
                for popmod in range(k):
                    count = dp[tight][popmod]
                    if not count:
                        continue

                    for bit in (0,1):
                        if tight == 1 and bit > upper:
                            continue
                        new_tight = 1 if (tight == 1 and bit == upper) else 0
                        new_popmod = (popmod + bit) % k
                        next_dp[new_tight][new_popmod] = (next_dp[new_tight][new_popmod] + count) % MOD

            dp = next_dp

        result = (dp[0][0] + dp[1][0]) % MOD
        print(result)

if __name__ == "__main__":
    sys.setrecursionlimit(10**7)
    Solution().Main()
