import sys

MOD = 10 ** 9 + 7


class Solution:
    def Main(self):
        input_line = sys.stdin.readline().split()
        n = int(input_line[0])
        k = int(input_line[1])
        rStr = sys.stdin.readline().strip()

        binaryDigits = self.DecimalStringToBinaryDigits(rStr)
        result = self.CountNumbersWithPopcountMod0(binaryDigits, k)
        print(result % MOD)

    def DecimalStringToBinaryDigits(self, decimalStr):
        num = int(decimalStr)
        if num == 0:
            return [0]
        bits = []
        while num:
            bits.append(num & 1)
            num >>= 1
        return bits[::-1]

    def CountNumbersWithPopcountMod0(self, bits, k):
        bit_len = len(bits)
        prev_dp = [[0] * k for _ in range(2)]
        prev_dp[1][0] = 1

        for i in range(bit_len):
            curr_dp = [[0] * k for _ in range(2)]
            upper = bits[i]

            for tight in (0, 1):
                prev_dp_tight = prev_dp[tight]
                for popmod in range(k):
                    count = prev_dp_tight[popmod]
                    if count == 0:
                        continue


                    new_tight = 1 if tight and 0 == upper else 0
                    curr_dp[new_tight][popmod] = (curr_dp[new_tight][popmod] + count) % MOD

                    if not tight or 1 <= upper:
                        new_tight = 1 if tight and 1 == upper else 0
                        new_popmod = (popmod + 1) % k
                        curr_dp[new_tight][new_popmod] = (curr_dp[new_tight][new_popmod] + count) % MOD

            prev_dp = curr_dp

        return (prev_dp[0][0] + prev_dp[1][0]) % MOD


if __name__ == "__main__":
    sys.setrecursionlimit(10 ** 7)
    Solution().Main()
