import sys

MOD = 1000000007


class Solution:
    def Main(self):
        inputLine = sys.stdin.readline().strip().split()
        n = int(inputLine[0])
        k = int(inputLine[1])
        rStr = sys.stdin.readline().strip()

        binaryDigits = self.DecimalStringToBinaryDigits(rStr)

        result = self.CountNumbersWithPopcountMod0(binaryDigits, k)
        print(result)

    def DecimalStringToBinaryDigits(self, decimalStr: str) -> list[int]:
        if decimalStr == "0":
            return [0]

        num = int(decimalStr)
        binaryDigits = []
        while num > 0:
            binaryDigits.append(num % 2)
            num //= 2

        binaryDigits.reverse()
        return binaryDigits if binaryDigits else [0]

    def CountNumbersWithPopcountMod0(self, binaryDigits: list[int], k: int) -> int:
        bitLength = len(binaryDigits)
        if k == 0:
            return 1

        prev_dp = [[0] * k for _ in range(2)]
        prev_dp[1][0] = 1

        for pos in range(bitLength):
            curr_dp = [[0] * k for _ in range(2)]
            upper = binaryDigits[pos]

            for tight in range(2):
                for popMod in range(k):
                    if prev_dp[tight][popMod] == 0:
                        continue

                    newTight0 = 1 if tight and 0 == upper else 0
                    newPopMod0 = (popMod + 0) % k
                    curr_dp[newTight0][newPopMod0] = (curr_dp[newTight0][newPopMod0] +
                                                      prev_dp[tight][popMod]) % MOD

                    if tight == 0 or 1 <= upper:
                        newTight1 = 1 if tight and 1 == upper else 0
                        newPopMod1 = (popMod + 1) % k
                        curr_dp[newTight1][newPopMod1] = (curr_dp[newTight1][newPopMod1] +
                                                          prev_dp[tight][popMod]) % MOD

            prev_dp = curr_dp

        return (prev_dp[0][0] + prev_dp[1][0]) % MOD


if __name__ == "__main__":
    sys.setrecursionlimit(10 ** 6)
    Solution().Main()
