import sys

MOD = 1000000007


def Main():
    inputLine = sys.stdin.readline().strip().split()
    n = int(inputLine[0])
    k = int(inputLine[1])
    rStr = sys.stdin.readline().strip()

    binaryDigits = DecimalToBinaryDigits(rStr)

    dp = [[[-1] * 2 for _ in range(k)] for _ in range(128)]

    result = CountNumbersWithPopcountMod0(0, 0, 1, binaryDigits, k, dp)
    print(result)


def DecimalToBinaryDigits(decimalStr: str) -> list[int]:
    if decimalStr == "0":
        return [0]

    digits = [int(c) for c in decimalStr]
    binaryDigits = []

    while any(d > 0 for d in digits):
        remainder = 0
        newDigits = []

        for digit in digits:
            current = remainder * 10 + digit
            newDigits.append(current // 2)
            remainder = current % 2

        i = 0
        while i < len(newDigits) and newDigits[i] == 0:
            i += 1

        digits = newDigits[i:] if i < len(newDigits) else [0]
        binaryDigits.append(remainder)

    binaryDigits.reverse()
    return binaryDigits


def CountNumbersWithPopcountMod0(pos: int, popMod: int, tight: int,
                                 binaryDigits: list[int], k: int, dp: list) -> int:
    if pos == len(binaryDigits):
        return 1 if popMod == 0 else 0

    if dp[pos][popMod][tight] != -1:
        return dp[pos][popMod][tight]

    result = 0
    upper = binaryDigits[pos] if tight else 1

    for bit in range(upper + 1):
        newTight = 1 if tight and bit == upper else 0
        newPopMod = (popMod + bit) % k
        result = (result + CountNumbersWithPopcountMod0(
            pos + 1, newPopMod, newTight, binaryDigits, k, dp)) % MOD

    dp[pos][popMod][tight] = result
    return result


if __name__ == "__main__":
    sys.setrecursionlimit(10 ** 6)
    Main()
