def BuildMinPrimeSieve(limit):
    minPrime = [0] * (limit + 1)
    for i in range(2, limit + 1):
        minPrime[i] = i

    for i in range(2, int(limit ** 0.5) + 1):
        if minPrime[i] == i:
            for j in range(i * i, limit + 1, i):
                if minPrime[j] == j:
                    minPrime[j] = i
    minPrime[0] = minPrime[1] = 1
    return minPrime


def IsOddPowered(number, minPrime):
    if number < 2:
        return False

    original = number
    while number > 1:
        primeFactor = minPrime[number]
        exponentCount = 0
        while number % primeFactor == 0:
            number //= primeFactor
            exponentCount += 1
        if exponentCount % 2 == 0:
            return False
    return True


def FindOddPoweredSequence(m, leftBound, rightBound, minPrime):
    isOddPowered = [False] * (rightBound + 1)

    for i in range(max(2, leftBound), rightBound + 1):
        isOddPowered[i] = IsOddPowered(i, minPrime)

    consecutive = 0
    for i in range(leftBound, rightBound + 1):
        if isOddPowered[i]:
            consecutive += 1
            if consecutive == m:
                return [str(num) for num in range(i - m + 1, i + 1)]
        else:
            consecutive = 0

    return None


def Main():
    m = int(input())
    leftBoundary, rightBoundary = map(int, input().split())

    sieve = BuildMinPrimeSieve(rightBoundary)
    result = FindOddPoweredSequence(m, leftBoundary, rightBoundary, sieve)

    if result:
        print(' '.join(result))
    else:
        print(-1)


if __name__ == "__main__":
    Main()
