def BuildMinPrimeSieve(limit):
    minPrime = list(range(limit + 1))
    minPrime[0] = minPrime[1] = 1

    for i in range(2, int(limit ** 0.5) + 1):
        if minPrime[i] == i:
            for j in range(i * i, limit + 1, i):
                if minPrime[j] == j:
                    minPrime[j] = i
    return minPrime


def IsOddPowered(number, minPrime):
    if number < 2:
        return False

    current = number
    while current > 1:
        primeFactor = minPrime[current]
        exponentCount = 0
        while current % primeFactor == 0:
            current //= primeFactor
            exponentCount += 1
        if exponentCount % 2 == 0:
            return False
    return True


def FindOddPoweredSequence(m, leftBound, rightBound, minPrime):
    maxStartPosition = rightBound - m + 1
    for startPosition in range(leftBound, maxStartPosition + 1):
        sequenceIsValid = True
        for offset in range(m):
            currentNumber = startPosition + offset
            if not IsOddPowered(currentNumber, minPrime):
                sequenceIsValid = False
                break

        if sequenceIsValid:
            return [str(num) for num in range(startPosition, startPosition + m)]

    return None


def Main():
    sequenceLength = int(input())
    leftBoundary, rightBoundary = map(int, input().split())

    smallestPrimeFactors = BuildMinPrimeSieve(rightBoundary)

    resultSequence = FindOddPoweredSequence(
        sequenceLength,
        leftBoundary,
        rightBoundary,
        smallestPrimeFactors
    )

    if resultSequence is not None:
        print(' '.join(resultSequence))
    else:
        print(-1)


if __name__ == "__main__":
    Main()
