def BuildMinPrimeSieve(limit):
    if limit < 2:
        return [1] * (limit + 1)
    sieve_size = (limit + 7) // 8
    sieve = bytearray(sieve_size)
    minPrime = [0, 1, 2] + [0] * (limit - 2)
    for i in range(4, limit + 1, 2):
        minPrime[i] = 2
    for i in range(3, int(limit**0.5) + 1, 6):
        if minPrime[i] == 0:
            for j in range(i*i, limit + 1, i):
                if minPrime[j] == 0:
                    minPrime[j] = i
        if minPrime[i + 2] == 0:
            for j in range((i + 2)*(i + 2), limit + 1, i + 2):
                if minPrime[j] == 0:
                    minPrime[j] = i + 2
    for i in range(3, limit + 1):
        if minPrime[i] == 0:
            minPrime[i] = i
    return minPrime


def IsOddPoweredFast(number, minPrime):
    if number % 2 == 0:
        count2 = 0
        while number % 2 == 0:
            number //= 2
            count2 += 1
        if count2 % 2 == 0:
            return False
    if number == 1:
        return True
    while number > 1:
        p = minPrime[number]
        count = 0
        while number % p == 0:
            number //= p
            count += 1
        if count % 2 == 0:
            return False
    return True


def FindOddPoweredSequence(m, leftBound, rightBound, minPrime):
    isOddPowered = [False] * (rightBound - leftBound + 1)
    for i in range(max(2, leftBound), rightBound + 1):
        isOddPowered[i - leftBound] = IsOddPoweredFast(i, minPrime)
    consecutive = 0
    for i in range(leftBound, rightBound + 1):
        idx = i - leftBound
        if isOddPowered[idx]:
            consecutive += 1
            if consecutive == m:
                return [str(num) for num in range(i - m + 1, i + 1)]
        else:
            consecutive = 0
    return None


def Main():
    m = int(input())
    leftBoundary, rightBoundary = map(int, input().split())
    sieve = BuildMinPrimeSieve(rightBoundary)
    result = FindOddPoweredSequence(m, leftBoundary, rightBoundary, sieve)
    if result:
        print(' '.join(result))
    else:
        print(-1)


if __name__ == "__main__":
    Main()
