﻿using System;

public static class Program
{
    public static void Main(string[] args)
    {
        long n = ReadLong();
        long m = ReadLong();
        int k = ReadInt();

        long[] counts = new long[k];
        ProcessDiagonals(n, m, k, counts);
        PrintCounts(counts);
    }

    private static long ReadLong()
    {
        return long.Parse(Console.ReadLine().Trim());
    }

    private static int ReadInt()
    {
        return int.Parse(Console.ReadLine().Trim());
    }

    private static void ProcessDiagonals(long n, long m, int k, long[] counts)
    {
        for (long d = 0; d < n + m - 1; d++)
        {
            long low = Math.Max(0, d - m + 1);
            long high = Math.Min(d, n - 1);
            long length = Math.Max(0, high - low + 1);

            int color = (int)(d % k);
            counts[color] += length;
        }
    }

    private static void PrintCounts(long[] counts)
    {
        foreach (long count in counts)
        {
            Console.WriteLine(count);
        }
    }
}
