def CountColors(n: int, m: int, k: int) -> list[int]:
    if n > m:
        n, m = m, n

    totalDiags = n + m - 1
    colorCounts = [0] * k

    for colorIndex in range(k):
        firstGrowthDiag = colorIndex
        if firstGrowthDiag < n:
            growthCount = (n - firstGrowthDiag - 1) // k + 1
            firstLength = firstGrowthDiag + 1
            lastLength = firstGrowthDiag + 1 + (growthCount - 1) * k
            colorCounts[colorIndex] += growthCount * (firstLength + lastLength) // 2

        firstPlateauDiag = n + (colorIndex - n % k + k) % k
        plateauEndDiag = m - 1
        if firstPlateauDiag <= plateauEndDiag:
            plateauCount = ((plateauEndDiag - firstPlateauDiag) // k) + 1
            colorCounts[colorIndex] += plateauCount * n

        firstDecreaseDiag = m + (colorIndex - m % k + k) % k
        decreaseEndDiag = totalDiags - 1
        if firstDecreaseDiag <= decreaseEndDiag:
            decreaseCount = ((decreaseEndDiag - firstDecreaseDiag) // k) + 1
            firstDecLength = totalDiags - firstDecreaseDiag
            lastDecLength = totalDiags - (firstDecreaseDiag + (decreaseCount - 1) * k)
            colorCounts[colorIndex] += decreaseCount * (firstDecLength + lastDecLength) // 2

    return colorCounts


n = int(input())
m = int(input())
k = int(input())

result = CountColors(n, m, k)
for count in result:
    print(count)
