def ReadInput():
    n = int(input().strip())
    m = int(input().strip())
    k = int(input().strip())
    return n, m, k


def CalculateDiagonalCounts(n, m, k):
    counts = [0] * k
    totalDiagonals = n + m - 1

    for d in range(totalDiagonals):
        low = max(0, d - m + 1)
        high = min(d, n - 1)
        length = max(0, high - low + 1)
        color = d % k
        counts[color] += length

    return counts


def PrintCounts(counts):
    for count in counts:
        print(count)


def main():
    n, m, k = ReadInput()
    counts = CalculateDiagonalCounts(n, m, k)
    PrintCounts(counts)


if __name__ == "__main__":
    main()
