import sys


def solve():
    try:

        line1 = sys.stdin.readline()
        if not line1:
            return
        parts1 = list(map(int, line1.split()))
        if not parts1:
            line1 = sys.stdin.readline()
            if not line1:
                return
            parts1 = list(map(int, line1.split()))

        if len(parts1) == 1:
            m = parts1[0]
            line2 = sys.stdin.readline()
            if not line2:
                return
            parts2 = list(map(int, line2.split()))
            l, r = parts2[0], parts2[1]
        else:

            m, l, r = parts1[0], parts1[1], parts1[2]

    except EOFError:
        return
    except ValueError:
        return


    max_val = r

    limit_sqrt = int(max_val ** 0.5) + 1
    is_prime = [True] * limit_sqrt
    is_prime[0] = is_prime[1] = False
    for p in range(2, int(limit_sqrt ** 0.5) + 1):
        if is_prime[p]:
            for i in range(p * p, limit_sqrt, p):
                is_prime[i] = False

    primes = [p for p, prime_status in enumerate(is_prime) if prime_status]


    is_odd_powered = [True] * (r - l + 1)


    for p in primes:
        p_squared = p * p

        start = (l + p_squared - 1) // p_squared * p_squared

        if start < l:
            start += p_squared

        if start > r:
            continue


        for i in range(start, r + 1, p_squared):
            is_odd_powered[i - l] = False

    count_consecutive = 0
    start_index = -1

    for i in range(r - l + 1):
        if is_odd_powered[i]:
            count_consecutive += 1
            if count_consecutive == m:

                start_index = i - m + 1
                break
        else:

            count_consecutive = 0


    if start_index != -1:
        result = []
        for i in range(m):
            result.append(str(l + start_index + i))
        print(" ".join(result))
    else:
        print("-1")


if __name__ == "__main__":
    solve()
