import sys


def solve():
    try:
        line = sys.stdin.read().split()
        if not line:
            return
        n = int(line[0])
        m = int(line[1])
        k = int(line[2])
    except (IndexError, ValueError):
        return

    counts = [0] * k

    def count_cells_up_to(s):
        if s <= 0:
            return 0
        if s <= n:
            return s * (s + 1) // 2
        if s <= m:
            return n * (s - n) + n * (n + 1) // 2
        if s <= n + m:
            return n * m - (n + m - s) * (n + m - s + 1) // 2
        return n * m

    for c in range(k):
        total_full_periods = (n + m - 1) // k

        start_s = c + 1
        end_s = total_full_periods * k + c + 1

        if end_s > n + m:
            end_s = n + m

        cells = count_cells_up_to(end_s) - count_cells_up_to(start_s - 1)

        counts[c] = cells

    print(*(counts))


if __name__ == '__main__':
    solve()
