#include <bits/stdc++.h>
using namespace std;

long long skolko_v_intervalle(long long L, long long R, long long K, long long ost) {
    if (L > R) return 0;
    
    long long pervoe = L;
    long long tek_ost = pervoe % K;
    if (tek_ost != ost) {
        long long raznica = ost - tek_ost;
        if (raznica < 0) raznica += K;
        pervoe += raznica;
    }
    
    if (pervoe > R) return 0;
    
    return (R - pervoe) / K + 1;
}

int main() {
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);
    
    long long n, m, k;
    cin >> n >> m >> k;
    
    vector<long long> otvet(k, 0);
    
    if (n > m) swap(n, m);
    
    for (long long cvet = 0; cvet < k; cvet++) {
        long long vsego = 0;
        
        long long d_min = 1;
        long long d_max = n;
        
        for (long long d = d_min; d <= d_max; d++) {
            long long nachalo = d;
            long long konec = d;
            long long skolko_diag = 1;
            
            if (d == n) {
                konec = d + (m - n);
                skolko_diag = m - n + 1;
            }
            
            vsego += d * skolko_v_intervalle(nachalo, konec, k, cvet);
        }
        
        for (long long d = n - 1; d >= 1; d--) {
            long long nomer = m + (n - d);
            vsego += d * skolko_v_intervalle(nomer, nomer, k, cvet);
        }
        
        otvet[cvet] = vsego;
    }
    
    for (long long i = 0; i < k; i++) {
        cout << otvet[i] << "\n";
    }
    
    return 0;
}