import sys
from itertools import combinations

def readints():
    return list(map(int, sys.stdin.readline().split()))

def point_on_segment(px, py, x1, y1, x2, y2):
    if x1 == x2:
        return px == x1 and min(y1, y2) <= py <= max(y1, y2)
    if y1 == y2:
        return py == y1 and min(x1, x2) <= px <= max(x1, x2)
    return False

def line_touches_rect(A, B, C, x1, y1, x2, y2):
    vertices = [(x1, y1), (x2, y1), (x2, y2), (x1, y2)]
    for vx, vy in vertices:
        if A * vx + B * vy + C == 0:
            return True

    sides = [
        (x1, y1, x2, y1),
        (x2, y1, x2, y2),
        (x2, y2, x1, y2),
        (x1, y2, x1, y1)
    ]
    for sx1, sy1, sx2, sy2 in sides:
        val1 = A * sx1 + B * sy1 + C
        val2 = A * sx2 + B * sy2 + C
        if val1 == 0 or val2 == 0:
            return True
        if (val1 < 0 and val2 > 0) or (val1 > 0 and val2 < 0):
            return True
    return False

def find_common_tangent(rects):
    n = len(rects)
    if n == 1:
        return True

    points = []
    for x1, y1, x2, y2 in rects:
        points.append((x1, y1))
        points.append((x2, y1))
        points.append((x2, y2))
        points.append((x1, y2))

    for i in range(len(points)):
        for j in range(i + 1, len(points)):
            px1, py1 = points[i]
            px2, py2 = points[j]

            A = py2 - py1
            B = px1 - px2
            C = px2 * py1 - px1 * py2

            if A == 0 and B == 0:
                continue

            ok = True
            for x1, y1, x2, y2 in rects:
                if not line_touches_rect(A, B, C, x1, y1, x2, y2):
                    ok = False
                    break
            if ok:
                return True

    x_coords = set()
    y_coords = set()
    for x1, y1, x2, y2 in rects:
        x_coords.add(x1)
        x_coords.add(x2)
        y_coords.add(y1)
        y_coords.add(y2)

    for x in x_coords:
        A, B, C = 1, 0, -x
        ok = True
        for x1, y1, x2, y2 in rects:
            if not (x1 <= x <= x2):
                ok = False
                break
        if ok:
            return True

    for y in y_coords:
        A, B, C = 0, 1, -y
        ok = True
        for x1, y1, x2, y2 in rects:
            if not (y1 <= y <= y2):
                ok = False
                break
        if ok:
            return True

    return False

def main():
    input = sys.stdin.read().split()
    ptr = 0
    T = int(input[ptr])
    ptr += 1
    for _ in range(T):
        n = int(input[ptr])
        ptr += 1
        rects = []
        for i in range(n):
            x1 = int(input[ptr])
            y1 = int(input[ptr+1])
            x2 = int(input[ptr+2])
            y2 = int(input[ptr+3])
            ptr += 4
            rects.append((x1, y1, x2, y2))


        if find_common_tangent(rects):
            print("Yes")
        else:
            print("No")

if __name__ == "__main__":
    main()