def precompute_spf(max_n):
    spf = list(range(max_n + 1))
    for i in range(2, int(max_n ** 0.5) + 1):
        if spf[i] == i:
            for j in range(i * i, max_n + 1, i):
                if spf[j] == j:
                    spf[j] = i
    return spf


def is_odd_power_number(n, spf):
    if n == 1:
        return True
    temp = n
    while temp > 1:
        p = spf[temp]
        count = 0
        while temp % p == 0:
            count += 1
            temp //= p
        if count % 2 == 0:
            return False
    return True


def main():
    import sys
    input = sys.stdin.read
    data = input().split()

    m = int(data[0])
    l = int(data[1])
    r = int(data[2])


    spf = precompute_spf(r)

    is_magic = [False] * (r + 1)
    for i in range(2, r + 1):
        is_magic[i] = is_odd_power_number(i, spf)

    current_count = 0
    result = []

    for num in range(l, r + 1):
        if is_magic[num]:
            current_count += 1
            result.append(num)
            if current_count >= m:
                print(' '.join(map(str, result[:m])))
                return
        else:
            current_count = 0
            result = []

    print(-1)


if __name__ == "__main__":
    main()
