def count_diagonal_cells(n, m, d):
    """Возвращает число клеток на диагонали с номером d (0-индексация)"""
    return min(d + 1, n, m, n + m - d - 1)


def sum_arithmetic_segment(a, b, step):
    """Сумма арифметической прогрессии от a до b с шагом step"""
    if a > b:
        return 0
    count = (b - a) // step + 1
    return (a + b) * count // 2


def solve_optimized(n, m, k):
    colors = [0] * k
    max_d = n + m - 2

    for r in range(k):
        d_start = r
        d_end = r + k * ((max_d - r) // k)

        if d_start > max_d:
            continue

        min_nm = min(n, m)
        max_nm = max(n, m)

        zone1_end = min_nm - 1
        zone2_end = max_nm - 1

        seg_start = max(d_start, 0)
        seg_end = min(d_end, zone1_end)
        if seg_start <= seg_end:
            first = seg_start
            last = seg_end
            if first % k != r:
                first += (r - first % k + k) % k
            if last % k != r:
                last -= (last % k - r + k) % k

            if first <= last:
                terms = (last - first) // k + 1
                total = (first + 1 + last + 1) * terms // 2
                colors[r] += total

        seg_start = max(d_start, min_nm)
        seg_end = min(d_end, zone2_end)
        if seg_start <= seg_end:
            first = seg_start
            if first % k != r:
                first += (r - first % k + k) % k
            last = seg_end
            if last % k != r:
                last -= (last % k - r + k) % k

            if first <= last:
                count = (last - first) // k + 1
                colors[r] += min_nm * count

        seg_start = max(d_start, max_nm)
        seg_end = min(d_end, max_d)
        if seg_start <= seg_end:
            first = seg_start
            if first % k != r:
                first += (r - first % k + k) % k
            last = seg_end
            if last % k != r:
                last -= (last % k - r + k) % k

            if first <= last:
                terms = (last - first) // k + 1
                sum_d = (first + last) * terms // 2
                total = (n + m - 1) * terms - sum_d
                colors[r] += total

    return colors


def main():
    n = int(input())
    m = int(input())
    k = int(input())

    result = solve_optimized(n, m, k)

    for count in result:
        print(count)


if __name__ == "__main__":
    main()
