def on_segment(p, q, r):
    if (min(p[0], r[0]) <= q[0] <= max(p[0], r[0]) and 
        min(p[1], r[1]) <= q[1] <= max(p[1], r[1])):
        return True
    return False

def orientation(p, q, r):
    val = (q[1] - p[1]) * (r[0] - q[0]) - (q[0] - p[0]) * (r[1] - q[1])
    if val == 0:
        return 0  
    return 1 if val > 0 else 2 

def segments_intersect(p1, q1, p2, q2):
    o1 = orientation(p1, q1, p2)
    o2 = orientation(p1, q1, q2)
    o3 = orientation(p2, q2, p1)
    o4 = orientation(p2, q2, q1)
    if o1 != o2 and o3 != o4:
        return True
    if o1 == 0 and on_segment(p1, p2, q1): return True
    if o2 == 0 and on_segment(p1, q2, q1): return True
    if o3 == 0 and on_segment(p2, p1, q2): return True
    if o4 == 0 and on_segment(p2, q1, q2): return True
    return False

def rect_corners(x1, y1, x2, y2):
    return [(x1, y1), (x1, y2), (x2, y1), (x2, y2)]

def line_crosses_rect(line_start, line_end, rect):
    rect_corners_list = rect_corners(*rect)
    edges = [
        (rect_corners_list[0], rect_corners_list[1]),
        (rect_corners_list[1], rect_corners_list[2]),
        (rect_corners_list[2], rect_corners_list[3]),
        (rect_corners_list[3], rect_corners_list[0])
    ]
    for edge_start, edge_end in edges:
        if segments_intersect(line_start, line_end, edge_start, edge_end):
            return True
    min_x, max_x = min(r[0] for r in rect_corners_list), max(r[0] for r in rect_corners_list)
    min_y, max_y = min(r[1] for r in rect_corners_list), max(r[1] for r in rect_corners_list)
    
    def inside_rect(p):
        return min_x <= p[0] <= max_x and min_y <= p[1] <= max_y
    
    if inside_rect(line_start) and inside_rect(line_end):
        return True
    return False

def solve():
    n = int(input())
    rectangles = []
    for _ in range(n):
        x1, y1, x2, y2 = map(int, input().split())
        rectangles.append((min(x1, x2), min(y1, y2), max(x1, x2), max(y1, y2)))
    all_corners = []
    for rect in rectangles:
        all_corners.extend(rect_corners(*rect))
    for i in range(len(all_corners)):
        for j in range(i + 1, len(all_corners)):
            line_start = all_corners[i]
            line_end = all_corners[j]
            crosses_all = True
            for rect in rectangles:
                if not line_crosses_rect(line_start, line_end, rect):
                    crosses_all = False
                    break
            if crosses_all:
                print("Yes")
                return
    print("No")

for z in range(int(input())):
    solve()