import sys

sys.setrecursionlimit(2000000)

MOD = 10 ** 9 + 7


def decimal_to_binary(s):
    if s == "0":
        return "0"
    binary_digits = []
    digits = [int(c) for c in s]

    while digits:
        rem = 0
        for i in range(len(digits)):
            num = rem * 10 + digits[i]
            digits[i] = num // 2
            rem = num % 2
        binary_digits.append(str(rem))
        while digits and digits[0] == 0:
            digits.pop(0)

    return ''.join(reversed(binary_digits))


def solve():
    line = sys.stdin.readline().split()
    if not line: return

    if len(line) == 2:
        N = int(line[0])
        K = int(line[1])
    else:
        N = int(line[0])
        K = int(sys.stdin.readline().strip())

    R_str = sys.stdin.readline().strip()

    if K == 0:
        print(0)
        return

    R_bin = decimal_to_binary(R_str)
    m = len(R_bin)
    prev_dp_tight = [0] * K
    prev_dp_loose = [0] * K
    prev_dp_tight[0] = 1

    for pos in range(m):
        curr_dp_tight = [0] * K
        curr_dp_loose = [0] * K
        max_bit_val = int(R_bin[pos])

        for cnt in range(K):
            if prev_dp_tight[cnt] == 0:
                continue
            val = prev_dp_tight[cnt]
            curr_dp_tight[cnt] = (curr_dp_tight[cnt] + val) % MOD

            if max_bit_val == 1:
                new_cnt_1 = (cnt + 1) % K
                curr_dp_loose[new_cnt_1] = (curr_dp_loose[new_cnt_1] + val) % MOD

        for cnt in range(K):
            if prev_dp_loose[cnt] == 0:
                continue
            val = prev_dp_loose[cnt]
            curr_dp_loose[cnt] = (curr_dp_loose[cnt] + val) % MOD
            new_cnt_1 = (cnt + 1) % K
            curr_dp_loose[new_cnt_1] = (curr_dp_loose[new_cnt_1] + val) % MOD

        prev_dp_tight = curr_dp_tight
        prev_dp_loose = curr_dp_loose

    result = (prev_dp_tight[0] + prev_dp_loose[0]) % MOD
    print(result)


if __name__ == "__main__":
    solve()
