MOD = 10 ** 9 + 7


def decimal_to_binary(s):
    if s == "0":
        return "0"

    binary_digits = []
    digits = [int(c) for c in s]

    while digits:
        rem = 0
        for i in range(len(digits)):
            num = rem * 10 + digits[i]
            digits[i] = num // 2
            rem = num % 2

        binary_digits.append(str(rem))

        if digits and digits[0] == 0:
            first_nonzero = 0
            while first_nonzero < len(digits) and digits[first_nonzero] == 0:
                first_nonzero += 1
            digits = digits[first_nonzero:]

    return ''.join(reversed(binary_digits))


def solve():
    import sys
    _, K = map(int, sys.stdin.readline().split())
    R_str = sys.stdin.readline().strip()

    if K == 0:
        print(0)
        return

    R_bin = decimal_to_binary(R_str)
    m = len(R_bin)

    prev_dp = [[0] * K for _ in range(2)]
    prev_dp[1][0] = 1

    for pos in range(m):
        curr_dp = [[0] * K for _ in range(2)]
        max_bit_val = int(R_bin[pos])

        for tight in range(2):
            for cnt in range(K):
                if prev_dp[tight][cnt] == 0:
                    continue

                # Итерация по возможным битам (0 или 1)
                for bit in range(max_bit_val + 1 if tight else 2):
                    new_tight = tight and (bit == max_bit_val)
                    new_cnt = (cnt + bit) % K
                    curr_dp[new_tight][new_cnt] = (
                                                          curr_dp[new_tight][new_cnt] + prev_dp[tight][cnt]
                                                  ) % MOD

        prev_dp = curr_dp
    result = (prev_dp[0][0] + prev_dp[1][0]) % MOD
    print(result)


if __name__ == "__main__":
    solve()
