MOD = 10 ** 9 + 7


def decimal_to_binary(s):
    if s == "0":
        return "0"

    binary = []
    digits = list(map(int, s))

    while digits and digits[0] != 0:
        rem = 0
        for i in range(len(digits)):
            num = rem * 10 + digits[i]
            digits[i] = num // 2
            rem = num % 2

        binary.append(str(rem))

        if digits and digits[0] == 0 and len(digits) > 1:
            digits.pop(0)

    return ''.join(reversed(binary))


def solve():
    import sys
    n, K = map(int, sys.stdin.readline().split())
    R = sys.stdin.readline().strip()
    R_bin = decimal_to_binary(R)
    m = len(R_bin)

    dp = [[[0] * K for _ in range(2)] for __ in range(m + 1)]
    dp[0][1][0] = 1

    for pos in range(m):
        for tight in range(2):
            for cnt in range(K):
                if dp[pos][tight][cnt] == 0:
                    continue
                max_bit = int(R_bin[pos]) if tight else 1
                for bit in range(0, max_bit + 1):
                    new_tight = tight and (bit == max_bit)
                    new_cnt = (cnt + bit) % K
                    dp[pos + 1][new_tight][new_cnt] = (
                                                              dp[pos + 1][new_tight][new_cnt] + dp[pos][tight][cnt]
                                                      ) % MOD


    result = (dp[m][0][0] + dp[m][1][0]) % MOD
    print(result)


solve()
