import sys
from functools import lru_cache

sys.set_int_max_str_digits(40000)


def solve():
    try:
        line1 = sys.stdin.readline().split()
        if not line1:
            return
        n = int(line1[0])
        K = int(line1[1])
        line2 = sys.stdin.readline().strip()
        if not line2:
            return
        R_str_dec = line2
    except (IndexError, ValueError):
        return

    if K == 0:
        pass

    R_int = int(R_str_dec)
    R_bin_str = bin(R_int)[2:]

    MOD = 10 ** 9 + 7
    L = len(R_bin_str)

    @lru_cache(None)
    def dp(index, current_popcount_mod_K, is_less_than_R):
        if index == L:
            return 1 if current_popcount_mod_K == 0 else 0

        upper_bound = int(R_bin_str[index]) if not is_less_than_R else 1
        count = 0

        for digit in range(upper_bound + 1):
            new_is_less = is_less_than_R or (digit < upper_bound)
            new_popcount_mod_K = (current_popcount_mod_K + digit) % K
            count = (count + dp(index + 1, new_popcount_mod_K, new_is_less)) % MOD

        return count

    result = dp(0, 0, False)
    print(result)


if __name__ == "__main__":
    solve()
