import sys


def solve():
    try:
        # Быстрое чтение m, l и r
        line1 = sys.stdin.readline()
        if not line1:
            return
        parts1 = line1.split()
        if not parts1:
            line1 = sys.stdin.readline()
            parts1 = line1.split()

        if len(parts1) == 1:
            m = int(parts1[0])
            line2 = sys.stdin.readline()
            parts2 = line2.split()
            l = int(parts2[0])
            r = int(parts2[1])
        else:
            m = int(parts1[0])
            l = int(parts1[1])
            r = int(parts1[2])

    except (IndexError, ValueError):
        return

    max_r = 1000000
    # Массив is_odd_powered[i] будет True, если число i нечётно-степенное
    is_odd_powered = [True] * (max_r + 1)
    if max_r >= 0:
        is_odd_powered[0] = False
    if max_r >= 1:
        is_odd_powered[1] = False

    # Модифицированное решето: помечаем числа, которые делятся на квадрат простого числа
    for p in range(2, int(max_r ** 0.5) + 1):
        if is_odd_powered[p]:
            p_squared = p * p
            # Все числа, делящиеся на p*p, не являются нечётно-степенными
            for i in range(p_squared, max_r + 1, p_squared):
                is_odd_powered[i] = False

    # Поиск первой последовательности из m подряд идущих чисел в диапазоне [l, r]
    count_consecutive = 0
    start_index = l
    for i in range(l, r + 1):
        if is_odd_powered[i]:
            count_consecutive += 1
            if count_consecutive >= m:
                # Последовательность найдена, выводим ее
                start_seq = i - m + 1
                print(*(list(range(start_seq, i + 1))))
                return
        else:
            count_consecutive = 0
            # Сбрасываем счетчик, следующая потенциальная последовательность начнется после текущего i

    # Если последовательность не найдена
    print("-1")


if __name__ == "__main__":
    solve()
