def count_magic(n):
    if n < 0:
        return 0
    divisible_by_7 = n // 7
    ends_with_7 = (n + 3) // 10
    intersection_count = (n >= 7) and (n - 7) // 70 + 1 or 0
    return divisible_by_7 + ends_with_7 - intersection_count

def find_kth_magic_number(k):
    low = 1
    high = 10**18
    ans = high

    while low <= high:
        mid = (low + high) // 2
        count = count_magic(mid)

        if count >= k:
            ans = mid
            high = mid - 1
        else:
            low = mid + 1
    return ans

k = int(input())
print(find_kth_magic_number(k))