def sum_f_over_ap(prog_start, prog_end, step_k, n_val, m_val):
    if prog_start > prog_end:
        return 0

    total_sum = 0

    interval_start = 2
    interval_end = min(m_val + 1, prog_end)

    if interval_start <= interval_end:
        first_S = prog_start
        while first_S < interval_start:
            first_S += step_k

        if first_S <= interval_end:
            num_terms = (interval_end - first_S) // step_k + 1
            sum_S_in_ap = num_terms * first_S + step_k * num_terms * (num_terms - 1) // 2
            total_sum += sum_S_in_ap - num_terms

    interval_start = m_val + 2
    interval_end = min(n_val + 1, prog_end)

    if interval_start <= interval_end:
        first_S = prog_start
        while first_S < interval_start:
            first_S += step_k

        if first_S <= interval_end:
            num_terms = (interval_end - first_S) // step_k + 1
            total_sum += num_terms * m_val

    interval_start = n_val + 2
    interval_end = min(n_val + m_val, prog_end)

    if interval_start <= interval_end:
        first_S = prog_start
        while first_S < interval_start:
            first_S += step_k

        if first_S <= interval_end:
            num_terms = (interval_end - first_S) // step_k + 1
            sum_S_in_ap = num_terms * first_S + step_k * num_terms * (num_terms - 1) // 2
            total_sum += (n_val + m_val + 1) * num_terms - sum_S_in_ap

    return total_sum


def solve():
    n = int(input())
    m = int(input())
    k = int(input())

    if n < m:
        n, m = m, n

    counts = [0] * k

    for c in range(k):
        prog_start_S = c + 2
        prog_end_S = n + m

        counts[c] = sum_f_over_ap(prog_start_S, prog_end_S, k, n, m)

    for count in counts:
        print(count)


solve()