def hamster_coloring(n, m, k):
    color_counts = [0] * k
    total_diagonals = n + m - 1

    for d in range(2, total_diagonals + 2):
        if d <= n + 1:
            num_cells = d - 1
        else:
            num_cells = (n + m + 1) - d

        color_index = (d - 2) % k
        color_counts[color_index] += num_cells

    return color_counts


import sys

input = sys.stdin.read
data = input().strip().split()
n = int(data[0])
m = int(data[1])
k = int(data[2])

result = hamster_coloring(n, m, k)
print('\n'.join(map(str, result)))
