def is_odd_power_number(n):
    # Проверяем, является ли n нечётно-степенным
    if n < 2:
        return False
    original_n = n
    for i in range(2, int(n ** 0.5) + 1):
        count = 0
        while n % i == 0:
            n //= i
            count += 1
        if count % 2 == 0 and count > 0:  # Если степень чётная
            return False
            # Если осталось больше 1, значит это простое число и степень его 1 (нечётная)
    return True


def find_odd_power_sequence(m, l, r):
    odd_power_numbers = []

    for n in range(l, r + 1):
        if is_odd_power_number(n):
            odd_power_numbers.append(n)

    # Теперь ищем последовательность из m подряд идущих нечётно-степенных чисел
    for i in range(len(odd_power_numbers) - m + 1):
        if odd_power_numbers[i + m - 1] - odd_power_numbers[i] == m - 1:
            return odd_power_numbers[i:i + m]

    return -1


# Чтение входных данных
m = int(input().strip())
l, r = map(int, input().strip().split())

result = find_odd_power_sequence(m, l, r)
if result == -1:
    print(-1)
else:
    print(" ".join(map(str, result)))