def is_odd_powered(n, prime_factors):
    for p in prime_factors:
        if p * p > n:
            break
        count = 0
        while n % p == 0:
            n //= p
            count += 1
        if count % 2 == 0:
            return False
    if n > 1:
        return True
    return True


def sieve(max_n):
    is_prime = [True] * (max_n + 1)
    p = 2
    while (p * p <= max_n):
        if is_prime[p]:
            for i in range(p * p, max_n + 1, p):
                is_prime[i] = False
        p += 1
    return [p for p in range(2, max_n + 1) if is_prime[p]]


def find_odd_powered_sequence(m, l, r):
    primes = sieve(10 ** 6)

    odd_powered_numbers = []

    for n in range(l, r + 1):
        if is_odd_powered(n, primes):
            odd_powered_numbers.append(n)

    for i in range(len(odd_powered_numbers) - m + 1):
        if all(odd_powered_numbers[j] + 1 == odd_powered_numbers[j + 1] for j in range(i, i + m - 1):
            return odd_powered_numbers[i:i + m]

    return -1



m = int(input())
l, r = map(int, input().split())


result = find_odd_powered_sequence(m, l, r)

if result == -1:
    print(-1)
else:
    print(" ".join(map(str, result)))