def count_colors(n, m, k):
    color_counts = [0] * k  # Список для хранения количества клеток каждого цвета

    # Проход по всем возможным значениям s
    for s in range(2, n + m + 1):
        # Количество клеток для текущей суммы индексов s
        min_i = max(1, s - m + 1)
        max_i = min(n, s)

        if min_i <= max_i:
            cell_count = max_i - min_i + 1
            color_index = (s - 2) % k  # Определяем цвет по индексу
            color_counts[color_index] += cell_count

    return color_counts


# Чтение входных данных
n = int(input().strip())
m = int(input().strip())
k = int(input().strip())

result = count_colors(n, m, k)

# Вывод результата
for count in result:
    print(count)