#include <iostream>
#include <vector>

int main() {
    long long n, m, k;
    std::cin >> n >> m >> k;

    std::vector<long long> counts(k, 0);

    // Проходимся по всем возможным суммам координат (i + j)
    for (long long sum = 2; sum <= n + m; ++sum) {
        // Определяем цвет для текущей суммы
        long long color = (sum - 2) % k;

        // Определяем границы строки и столбца для текущей суммы
        long long row_start = std::max(1LL, sum - m);
        long long row_end = std::min(n, sum - 1);

        // Количество клеток с текущим цветом и суммой координат
        long long count = std::max(0LL, row_end - row_start + 1);

        // Увеличиваем счетчик для соответствующего цвета
        counts[color] += count;
    }

    // Выводим результаты
    for (int i = 0; i < k; ++i) {
        std::cout << counts[i] << (i == k - 1 ? "" : " ");
    }
    std::cout << std::endl;

    return 0;
}


