def count_cells(n, m, k):
    # Массив для хранения количества клеток каждого цвета
    color_count = [0] * k

    # Общее количество диагоналей
    total_diagonals = n + m - 1

    for d in range(1, total_diagonals + 1):
        if d <= n:
            count = d  # Все клетки до d
        elif d <= m:
            count = n  # Не более чем n по высоте
        else:
            count = n + m - d  # Упираемся в границы

        # Индекс цвета
        color_index = (d - 1) % k
        color_count[color_index] += count

    return color_count


# Чтение входных данных
n, m, k = map(int, input().split())

# Получение результата
result = count_cells(n, m, k)

# Вывод результата
for count in result:
    print(count)