def count_valid_numbers(R, K):
    MOD = 10 ** 9 + 7

    # Преобразование числа R в двоичную систему
    binary = []
    while R > 0:
        binary.append(R % 2)
        R //= 2
    binary.reverse()  # Теперь у нас двоичное представление от старших к младшим битам

    n = len(binary)

    # dp[pos][count][tight]
    # pos - текущая позиция бита
    # count - количество единиц
    # tight - ограничение по числу R (1 - ограничен, 0 - нет)
    dp = [[[-1 for _ in range(2)] for _ in range(K)] for _ in range(n + 1)]

    def dfs(pos, count, tight):
        if count >= K:  # Если count уже больше K, то мы берем только count % K
            count %= K

        if pos == n:
            return 1 if count == 0 else 0

        if dp[pos][count][tight] != -1:
            return dp[pos][count][tight]

        limit = binary[pos] if tight else 1
        result = 0

        # Позиция текущего бита может быть 0 или 1
        for digit in range(0, limit + 1):
            result += dfs(pos + 1, count + digit, tight and (digit == limit))
            result %= MOD

        dp[pos][count][tight] = result
        return result

    # Запуск DFS
    return dfs(0, 0, 1)


# Чтение входных данных
n, K = map(int, input().split())
R = int(input().strip())

# Получение результата
result = count_valid_numbers(R, K)

# Вывод результата
print(result)