def count_cells(n, m, k):
    # Инициализируем массив для хранения количества клеток каждого цвета
    color_count = [0] * k

    # Проходим по всем возможным диагоналям
    for d in range(2, n + m + 1):
        if d <= n + 1:  # В пределах верхней границы
            count = min(d - 1, m)
        else:  # Выходим за верхнюю границу
            count = n + m - d

        if count > 0:  # Если на диагонали есть клетки
            color_index = (d - 1) % k  # Номер цвета
            color_count[color_index] += count

    return color_count

# Чтение входных данных
n = int(input())
m = int(input())
k = int(input())

# Получение результата
result = count_cells(n, m, k)

# Вывод результата
for count in result:
    print(count)