def count_colors(n, m, k):
    # Массив для хранения количества клеток каждого цвета
    color_counts = [0] * k

    # Проходим по всем возможным суммам индексов от 2 до n + m
    for s in range(2, n + m + 1):
        # Вычисляем границы по i
        i_min = max(1, s - m)
        i_max = min(n, s - 1)

        # Количество клеток на данной диагонали
        if i_min <= i_max:
            count = i_max - i_min + 1

            # Определяем цвет
            color_index = (s - 2) % k

            # Добавляем количество клеток в соответствующий цвет
            color_counts[color_index] += count

    return color_counts


# Чтение входных данных
n = int(input())
m = int(input())
k = int(input())

# Получение и вывод результата
result = count_colors(n, m, k)
for count in result:
    print(count)