#include <iostream>
#include <vector>

using namespace std;

int main() {
  long long n, m, k;
  cin >> n >> m >> k;

  vector<long long> counts(k, 0); // Вектор для хранения количества клеток каждого цвета

  for (long long color = 0; color < k; ++color) {
    long long start_diagonal = color + 2;  //Сумма координат i + j для определения цвета.
    //Клетки с суммой i+j, дающей одинаковый остаток при делении на k, имеют одинаковый цвет
    //например, если k = 3, цвет 0 будет для диагоналей 2, 5, 8... цвет 1 для 3, 6, 9... цвет 2 для 4, 7, 10..

    // Определяем, сколько диагоналей каждого цвета попадает на дорогу
    long long full_diagonals = (n + m - start_diagonal) / k + (((n + m - start_diagonal) % k) >= 0 ? 1 : 0); // Количество "полных" диагоналей, с которыми пересекается дорога от диагонали start_diagonal. если остаток (n + m - start_diagonal) % k неотрицательный + 1 и 0 в другом случае

    // Перебираем и считаем количество клеток каждого цвета
    for (long long diagonal_num = 0; diagonal_num <full_diagonals; ++diagonal_num)
     {
        long long current_diagonal = start_diagonal + (diagonal_num * k); //номер диагонали, которую мы обрабатываем
        long long cells = min(current_diagonal - 1, min(n, m + current_diagonal - 1 ) - (current_diagonal - 1 >= m ? current_diagonal - m : 0)); //кол-во ячеек данного цвета
        if(cells > 0)
        {
           counts[color] += cells;
        }
     }

  }

  for (int i = 0; i < k; ++i) {
    cout << counts[i] << (i == k - 1 ? "" : " ");
  }
  cout << endl;

  return 0;
}
